const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');
const fs = require('fs');
const path = require('path');

function checkPermission(interaction, requiredPermission) {
    // Null/undefined kontrolleri ekle
    if (!interaction || !interaction.guild || !interaction.member) {
        console.error('checkPermission: interaction, guild veya member undefined');
        return false;
    }

    const yetkiPath = path.join(__dirname, '../jsons/yetkiSistemi.json');
    
    if (!fs.existsSync(yetkiPath)) {
        return interaction.member.permissions.has(PermissionFlagsBits.Administrator);
    }

    try {
        const yetkiData = JSON.parse(fs.readFileSync(yetkiPath, 'utf8'));
        const guildData = yetkiData[interaction.guild.id];

        if (!guildData || !guildData[requiredPermission]) {
            return interaction.member.permissions.has(PermissionFlagsBits.Administrator);
        }

        return interaction.member.roles.cache.has(guildData[requiredPermission]) || 
               interaction.member.permissions.has(PermissionFlagsBits.Administrator);
    } catch (error) {
        console.error('checkPermission JSON parse hatası:', error);
        return interaction.member.permissions.has(PermissionFlagsBits.Administrator);
    }
}

module.exports = {
    checkPermission,
    data: new SlashCommandBuilder()
        .setName('yetkiayarla')
        .setDescription('Tüm komutlar için yetki ayarlarını yönetir')
        .addStringOption(option =>
            option.setName('islem')
                .setDescription('Yapılacak işlem türü')
                .setRequired(true)
                .addChoices(
                    { name: 'Araç Verme', value: 'aracver' },
                    { name: 'Ban', value: 'ban' },
                    { name: 'Unban', value: 'unban' },
                    { name: 'Ban Bilgi', value: 'banbilgi' },
                    { name: 'Ban Komutları (Hepsi)', value: 'ban,unban,banbilgi' },
                    { name: 'Envanter Görüntüleme', value: 'envantergoruntule' },
                    { name: 'Item Verme', value: 'itemver' },
                    { name: 'Item Silme', value: 'itemsil' },
                    { name: 'Item Komutları (Hepsi)', value: 'itemver,itemsil' },
                    { name: 'Meslek Verme', value: 'meslekver' },
                    { name: 'Oyuncu Bilgi', value: 'oyuncubilgi' },
                    { name: 'Oyuncu Listeleme', value: 'oyunculistele' },
                    { name: 'Para Ayarlama', value: 'paraayarla' },
                    { name: 'Para Verme', value: 'paraver' },
                    { name: 'Para Silme', value: 'parasil' },
                    { name: 'Para Komutları (Hepsi)', value: 'paraayarla,paraver,parasil' },
                    { name: 'Canlandırma (Revive)', value: 'revive' },
                    { name: 'Öldürme (Kill)', value: 'kill' },
                    { name: 'Whitelist Verme', value: 'whitelistver' },
                    { name: 'Whitelist Silme', value: 'whitelistsil' },
                    { name: 'Whitelist Bilgi', value: 'whitelistbilgi' },
                    { name: 'Whitelist Komutları (Hepsi)', value: 'whitelistver,whitelistsil,whitelistbilgi' }
                ))
        .addStringOption(option =>
            option.setName('eylem')
                .setDescription('Yapılacak eylem')
                .setRequired(true)
                .addChoices(
                    { name: 'Ayarla', value: 'ayarla' },
                    { name: 'Kaldır', value: 'kaldir' },
                    { name: 'Görüntüle', value: 'goruntuele' }
                ))
        .addRoleOption(option =>
            option.setName('rol')
                .setDescription('Yetkili rol (boş bırakılırsa sadece Administrator yetkisi gerekir)')
                .setRequired(false)),

    async execute(interaction) {
        try {
            await interaction.deferReply();

            const islem = interaction.options.getString('islem');
            const rol = interaction.options.getRole('rol');
            const eylem = interaction.options.getString('eylem');

            const yetkiPath = path.join(__dirname, '../jsons/yetkiSistemi.json');
            let yetkiData = {};

            if (fs.existsSync(yetkiPath)) {
                yetkiData = JSON.parse(fs.readFileSync(yetkiPath, 'utf8'));
            }

            if (!yetkiData[interaction.guild.id]) {
                yetkiData[interaction.guild.id] = {
                    aracver: null,
                    ban: null,
                    unban: null,
                    banbilgi: null,
                    envantergoruntule: null,
                    itemver: null,
                    itemsil: null,
                    meslekver: null,
                    oyuncubilgi: null,
                    oyunculistele: null,
                    paraayarla: null,
                    paraver: null,
                    parasil: null,
                    revive: null,
                    kill: null,
                    whitelistver: null,
                    whitelistsil: null,
                    whitelistbilgi: null
                };
            }

            const guildData = yetkiData[interaction.guild.id];

            if (eylem === 'goruntuele') {
                const embed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('🔐 Yetki Ayarları')
                    .setDescription('Mevcut komut yetki ayarları:')
                    .addFields(
                        {
                            name: '🚗 Araç Verme Yetkisi',
                            value: guildData.aracver ? `<@&${guildData.aracver}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🚫 Ban Yetkisi',
                            value: guildData.ban ? `<@&${guildData.ban}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '✅ Unban Yetkisi',
                            value: guildData.unban ? `<@&${guildData.unban}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '📋 Ban Bilgi Yetkisi',
                            value: guildData.banbilgi ? `<@&${guildData.banbilgi}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎒 Envanter Görüntüleme Yetkisi',
                            value: guildData.envantergoruntule ? `<@&${guildData.envantergoruntule}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '📦 Item Verme Yetkisi',
                            value: guildData.itemver ? `<@&${guildData.itemver}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🗑️ Item Silme Yetkisi',
                            value: guildData.itemsil ? `<@&${guildData.itemsil}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '💼 Meslek Verme Yetkisi',
                            value: guildData.meslekver ? `<@&${guildData.meslekver}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '👤 Oyuncu Bilgi Yetkisi',
                            value: guildData.oyuncubilgi ? `<@&${guildData.oyuncubilgi}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '📋 Oyuncu Listeleme Yetkisi',
                            value: guildData.oyunculistele ? `<@&${guildData.oyunculistele}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '⚙️ Para Ayarlama Yetkisi',
                            value: guildData.paraayarla ? `<@&${guildData.paraayarla}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '💰 Para Verme Yetkisi',
                            value: guildData.paraver ? `<@&${guildData.paraver}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '💸 Para Silme Yetkisi',
                            value: guildData.parasil ? `<@&${guildData.parasil}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '💉 Canlandırma (Revive) Yetkisi',
                            value: guildData.revive ? `<@&${guildData.revive}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '💀 Öldürme (Kill) Yetkisi',
                            value: guildData.kill ? `<@&${guildData.kill}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '✅ Whitelist Verme Yetkisi',
                            value: guildData.whitelistver ? `<@&${guildData.whitelistver}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🗑️ Whitelist Silme Yetkisi',
                            value: guildData.whitelistsil ? `<@&${guildData.whitelistsil}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '📋 Whitelist Bilgi Yetkisi',
                            value: guildData.whitelistbilgi ? `<@&${guildData.whitelistbilgi}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        }
                    )
                    .setFooter({ text: `RoveBot's • Yetki Sistemi` })
                    .setTimestamp();

                return await interaction.editReply({ embeds: [embed] });
            }

            if (eylem === 'kaldir') {
                const islemler = islem.split(',');
                let kaldirilanlar = [];

                islemler.forEach(i => {
                    if (guildData[i.trim()]) {
                        guildData[i.trim()] = null;
                        kaldirilanlar.push(i.trim());
                    }
                });

                if (kaldirilanlar.length === 0) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Hata')
                        .setDescription('Belirtilen işlemler için ayarlanmış yetki bulunamadı!')
                        .setTimestamp();

                    return await interaction.editReply({ embeds: [errorEmbed] });
                }

                fs.writeFileSync(yetkiPath, JSON.stringify(yetkiData, null, 2));

                const successEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('✅ Yetki Kaldırıldı')
                    .setDescription(`Aşağıdaki işlemler için yetki ayarları kaldırıldı:\n\n${kaldirilanlar.map(i => `• **${i.toUpperCase()}**`).join('\n')}`)
                    .addFields({
                        name: '📋 Not',
                        value: 'Artık bu işlemler sadece **Administrator** yetkisine sahip kullanıcılar tarafından kullanılabilir.',
                        inline: false
                    })
                    .setFooter({ text: `RoveBot's • Yetki Sistemi` })
                    .setTimestamp();

                return await interaction.editReply({ embeds: [successEmbed] });
            }

            if (eylem === 'ayarla') {
                if (!rol) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Hata')
                        .setDescription('Yetki ayarlamak için bir rol belirtmelisiniz!')
                        .setTimestamp();

                    return await interaction.editReply({ embeds: [errorEmbed] });
                }

                const islemler = islem.split(',');
                let ayarlananlar = [];

                islemler.forEach(i => {
                    guildData[i.trim()] = rol.id;
                    ayarlananlar.push(i.trim());
                });

                fs.writeFileSync(yetkiPath, JSON.stringify(yetkiData, null, 2));

                const successEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('✅ Yetki Ayarlandı')
                    .setDescription(`**${rol.name}** rolü aşağıdaki işlemler için yetkilendirildi:`)
                    .addFields({
                        name: '🔐 Yetkili İşlemler',
                        value: ayarlananlar.map(i => `• **${i.toUpperCase()}**`).join('\n'),
                        inline: false
                    })
                    .addFields({
                        name: '👥 Yetkili Rol',
                        value: `<@&${rol.id}>`,
                        inline: true
                    })
                    .addFields({
                        name: '📋 Not',
                        value: 'Bu rol artık belirtilen işlemleri kullanabilir. Administrator yetkisi olan kullanıcılar her zaman bu komutları kullanabilir.',
                        inline: false
                    })
                    .setFooter({ text: `RoveBot's • Yetki Sistemi` })
                    .setTimestamp();

                return await interaction.editReply({ embeds: [successEmbed] });
            }

        } catch (error) {
            console.error('Yetkiayarla komutunda hata:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Sistem Hatası')
                .setDescription('Yetki ayarları güncellenirken bir hata oluştu!')
                .setTimestamp();

            if (interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
};

