const { EmbedBuilder } = require('discord.js');
const fs = require('fs');
const path = require('path');

/**
 * Log gönderme fonksiyonu
 * @param {Object} client - Discord client
 * @param {String} guildId - Sunucu ID
 * @param {String} logType - Log türü (aracver, ban, vb.)
 * @param {Object} logData - Log verileri
 */
async function sendLog(client, guildId, logType, logData) {
    try {
        const logPath = path.join(__dirname, '../jsons/logKanallari.json');
        
        if (!fs.existsSync(logPath)) {
            return;
        }

        const logDataFile = JSON.parse(fs.readFileSync(logPath, 'utf8'));
        const guildLogData = logDataFile[guildId];

        if (!guildLogData || !guildLogData[logType]) {
            return;
        }

        const logChannelData = guildLogData[logType];
        const channel = await client.channels.fetch(logChannelData.channelId).catch(() => null);

        if (!channel) {
            return;
        }

        // Sunucu bilgilerini al
        const guild = client.guilds.cache.get(guildId);
        if (!guild) {
            return;
        }

        const guildIcon = guild.iconURL({ dynamic: true, size: 512 });
        const guildBanner = guild.bannerURL({ dynamic: true, size: 1024 });

        // Embed oluştur
        const embed = new EmbedBuilder()
            .setColor(logData.color || 0x3498db)
            .setTitle(logData.title || '📋 Log')
            .setDescription(logData.description || '')
            .setTimestamp()
            .setFooter({ text: `RoveBot's • Log Sistemi` });

        // Sunucu logosu (sağ üst küçük resim)
        if (guildIcon) {
            embed.setThumbnail(guildIcon);
        }

        // Sunucu banner (alt büyük resim)
        if (guildBanner) {
            embed.setImage(guildBanner);
        }

        // Fields ekle
        if (logData.fields && Array.isArray(logData.fields)) {
            logData.fields.forEach(field => {
                embed.addFields(field);
            });
        }

        // Kullanıcı bilgisi ekle
        if (logData.user) {
            embed.setAuthor({
                name: logData.user.tag || logData.user.username || 'Bilinmeyen Kullanıcı',
                iconURL: logData.user.displayAvatarURL({ dynamic: true })
            });
        }

        // Log kanalına gönder
        await channel.send({ embeds: [embed] });

    } catch (error) {
        console.error(`Log gönderme hatası (${logType}):`, error);
    }
}

module.exports = {
    sendLog
};

